#! /bin/sh

kernel_version=$(uname -r)
target_version="4.4.194"

current_major=$(echo $kernel_version | cut -d. -f1)
target_major=$(echo $target_version | cut -d. -f1)

if [ $current_major -lt $target_major ];then
    echo "updata..."
else
    echo "Please confirm the firmware version, unable to update."
    rm -rf /root/upgrade*
    exit 1
fi

destinationBathPath=/var/www/html/web_pages_Galleon/
commJSPath=/var/www/html/commJS/

if [ ! -f "/usr/sbin/openssl" ];then
	mv bin/openssl /usr/sbin
	chmod a+x /usr/sbin/openssl
fi

mv bin/upload.cgi "$destinationBathPath"/cgi-bin/
mv html/firmwareUpgrade.html "$destinationBathPath"
mv html/jquery.min.js "$commJSPath"

rm -rf /root/upgrade*

exit 0
